unit SimpleDO;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, DbOleCtl, DlsrLib_TLB, DLdefs, ExtCtrls;

type
  TForm1 = class(TForm)
    SR_DO: TDriverLINXSR;
    cmdWriteDO: TButton;
    lblDI: TLabel;
    txtDO: TEdit;
    SRDI: TDriverLINXSR;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cmdWriteDOClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
// Init the Digital Output
  SR_DO.Req_DLL_name := 'kmbpio';
// change name of driver as necessary for your hardware
// kpcipio, etc

  SR_DO.Req_device := 0;
// device number assigned in DLinx Config Panel

  SR_DO.req_mode := DL_Other;
  SR_DO.Req_op := DL_Initialize;
  SR_DO.Refresh;

// Init the Digital Input
  SRDI.Req_DLL_name := 'kmbpio';
  SRDI.Req_device := 0;

// use second SR with same board to independently
// do digital inputs from digital outputs
  SRDI.req_mode := DL_Other;
  SRDI.Req_op := DL_Initialize;
  SRDI.Refresh;

// Ports of PIO cards initialize as inputs by default
//  set up channel 0 for digital input
   // polled mode Digital Input
  SRDI.Req_subsystem := DL_DI;
  SRDI.Req_mode := DL_Polled;
  SRDI.Req_op := DL_Start;
  SRDI.Evt_Str_type := DL_NullEvent;
  SRDI.Evt_Stp_type := DL_Nullevent;
  SRDI.Evt_Tim_type := DL_Nullevent;
  SRDI.Sel_chan_format := DL_tNative;
  SRDI.Sel_chan_N := 1;
  SRDI.Sel_chan_start := 0;
  SRDI.Sel_chan_stop := 0;
  SRDI.Sel_chan_startGainCode := 0;
  SRDI.Sel_buf_N := 0;
  SRDI.Sel_buf_notify := DL_Noevents;


end;

procedure TForm1.cmdWriteDOClick(Sender: TObject);
var DOvalue : integer;
errcode : integer;
begin

// convert text box value to integer
val(txtDO.text,DOvalue,errcode);
// port is 8bit so verify we are in range
if DOvalue > 255 then DOValue := 255;
if DOvalue < 0 then DOValue := 0;
// assign this value to the inherent 1 reading property
SR_DO.Res_Sta_ioValue := DOValue;
SR_DO.Refresh;   // write the value
     
end;

procedure TForm1.Button1Click(Sender: TObject);
var DIResult : string[6];
begin
SRDI.Refresh;  // do the DI Read
// transfer this inherent 1 reading property of the SR
// to a local string
str(SRDI.res_sta_ioValue,DIResult);
lblDI.Caption := DIResult;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
// Configure Channel 1 for Output Mode

// ports are input by default on PIO-12 and PIO-24
// need to reconfigure for output mode

  SR_DO.Req_subsystem := DL_DO;
  SR_DO.Req_mode := DL_OTHER;
  SR_DO.Req_op := DL_CONFIGURE;
  SR_DO.Evt_Str_type := DL_NullEvent;
  SR_DO.Evt_Stp_type := DL_Nullevent;
  SR_DO.Evt_Tim_type := DL_DIOSETUP;
  SR_DO.Sel_chan_N := 0;           // how many channels
  SR_DO.Evt_Tim_dioChannel := 1;   // which channels
  SR_DO.Evt_Tim_dioMode := DL_DIO_BASIC;
  SR_DO.Refresh;

  // now that Chan 1 is configured for output
  // set up Service Request to use it
  // set up polled mode Digital Output
  SR_DO.Req_subsystem := DL_DO;
  SR_DO.Req_mode := DL_Polled;
  SR_DO.Req_op := DL_Start;
  SR_DO.Evt_Str_type := DL_NullEvent;
  SR_DO.Evt_Stp_type := DL_Nullevent;
  SR_DO.Evt_Tim_type := DL_Nullevent;
  SR_DO.Sel_chan_format := DL_tNative;
  SR_DO.Sel_chan_N := 1;         // how many channels
  SR_DO.Sel_chan_start := 1;     // which channels
  SR_DO.Sel_chan_stop := 1;
  SR_DO.Sel_chan_startGainCode := 0;
  SR_DO.Sel_buf_N := 0;
  SR_DO.Sel_buf_notify := DL_Noevents;

// now enable button to do writes to the channel
cmdWriteDO.Enabled := True;
end;

end.
